'\"
'\" Copyright (c) 2004 Joe English
'\"
.so man.macros
.TH notebook n 0.2 tile "Tile Widget Set"
.BS
.SH NAME
notebook \- Multi-paned container widget
.SH SYNOPSIS
\fBttk::notebook\fR \fIpathName \fR?\fIoptions\fR?
.BE
.SH DESCRIPTION
A \fBnotebook\fP widget manages a collection of subpanes 
and displays a single one at a time.
Each pane is associated with a tab, which the user
may select to change the currently-displayed pane.
.SO
\-class	\-cursor	\-takefocus	\-style
.SE
.SH "WIDGET OPTIONS"
.OP \-height height Height
If present and greater than zero, 
specifies the desired height of the pane area
(not including internal padding or tabs).
Otherwise, the maximum height of all panes is used.
.OP \-padding padding Padding
Specifies the amount of extra space to add around the outside
of the notebook.
The padding is a list of up to four length specifications 
\fIleft top right bottom\fR.
If fewer than four elements are specified, 
\fIbottom\fR defaults to \fItop\fR,
\fIright\fR defaults to \fIleft\fR, and 
\fItop\fR defaults to \fIleft\fR.
.OP \-width width Width
If present and greater than zero, 
specifies the desired width of the pane area
(not including internal padding).
Otherwise, the maximum width of all panes is used.
.SH "TAB OPTIONS"
The following options may be specified for individual notebook panes:
.OP \-state state State
Either \fBnormal\fP, \fBdisabled\fP or \fBhidden\fP.  
If \fBdisabled\fP, then the tab is not selectable. If \fBhidden\fP,
then the tab is not shown.
.OP \-sticky sticky Sticky
Specifies how the child pane is positioned within the pane area.
Value is a string containing zero or more of the characters
\fBn, s, e,\fR or \fBw\fR.
Each letter refers to a side (north, south, east, or west) 
that the child window will "stick" to,
as per the \fBgrid\fR geometry manager.
.OP \-padding padding Padding
Specifies the amount of extra space to add between the notebook and this pane.
Syntax is the same as for the widget \fB-padding\fP option.
.OP \-text text Text
Specifies a string to be displayed in the tab.
.OP \-image image Image
Specifies an image to display in the tab,
which must have been created with the \fBimage create\fR command.
.OP \-compound compound Compound
Specifies how to display the image relative to the text,
in the case both \fB-text\fR and \fB-image\fR are present.
See \fIlabel(n)\fR for legal values.
.OP \-underline underline Underline
Specifies the integer index (0-based) of a character to underline 
in the text string.
The underlined character is used for mnemonic activation
if \fBttk::notebook::enableTraversal\fR is called.
.SH "WIDGET COMMAND"
.TP
\fIpathname \fBadd \fIchild\fR ?\fIoptions...\fR?
Adds a new tab to the notebook.
When the tab is selected, the \fIchild\fR window
will be displayed.
\fIchild\fR must be a direct child of the notebook window.
See \fBTAB OPTIONS\fR for the list of available \fIoptions\fR.
.TP
\fIpathname \fBconfigure\fR ?\fIoptions\fR?
See \fIwidget(n)\fR.
.TP
\fIpathname \fBcget \fIoption\fR
See \fIwidget(n)\fR.
.TP
\fIpathname \fBforget \fIindex\fR
Removes the tab specified by \fIindex\fR,
unmaps and unmanages the associated child window.
.TP
\fIpathname \fBindex \fIindex\fR
Returns the numeric index of the tab specified by \fIindex\fR,
or the total number of tabs if \fIindex\fR is the string "\fBend\fR".
.TP
\fIpathname \fBinstate \fIargs...\fR?
See \fIwidget(n)\fR.
.TP
\fIpathname \fBselect \fIindex\fR
Selects the specified tab; the associated child pane will be displayed,
and the previously-selected pane (if different) is unmapped.
.TP
\fIpathname \fBstate\fR ?\fIstatespec\fR?
See \fIwidget(n)\fR.
.TP
\fIpathname \fBtab \fIindex\fR ?\fI-options \fR?\fIvalue ...\fR
Query or modify the options of the specific tab.
If no \fI-option\fR is specified, returns a dictionary of the tab option values.
If one \fI-option\fP is specified, returns the value of that \fIoption\fR.
Otherwise, sets the \fI-option\fRs to the corresponding \fIvalue\fRs.
See \fBTAB OPTIONS\fR for the available options.
.TP
\fIpathname \fBtabs\fR
Returns a list of all pane windows managed by the widget.
.\" Perhaps "panes" is a better name for this command?
.SH "KEYBOARD TRAVERSAL"
To enable keyboard traversal for a dialog box
containing a notebook widget \fI$nb\fR, call:
.CS
ttk::notebook::enableTraversal $nb
.CE
.PP
This will extend the bindings for the toplevel widget
containing the notebook as follows:
.IP \(bu
\fBControl-Tab\fR selects the tab following the currently selected one.
.IP \(bu
\fBShift-Control-Tab\fR selects the tab preceding the currently selected one.
\fIBUG: this doesn't currently work.\fR
.IP \(bu
\fBAlt-K\fP, where \fBK\fP is the mnemonic (underlined) character
of any tab, will select that tab.
.SH "TAB INDICES"
The \fIindex\fR argument to the above commands may take
any of the following forms:
.IP \(bu
An integer between zero and the number of tabs;
.IP \(bu
The name of a child pane window;
.IP \(bu
A positional specification of the form "@\fIx\fR,\fIy\fR",
which identifies the tab 
.IP \(bu
The literal string "\fBcurrent\fR",
which identifies the currently-selected tab; or:
.IP \(bu
The literal string "\fBend\fR",
which returns the number of tabs 
(only valid for "\fIpathname \fBindex\fR").

.SH "VIRTUAL EVENTS"
The notebook widget generates a \fB<<NotebookTabChanged>>\fP
virtual event after a new tab is selected.
.SH "EXAMPLE"
.CS
notebook .nb
\.nb add [frame .nb.f1] -text "First tab"
\.nb add [frame .nb.f2] -text "Second tab"
\.nb select .nb.f2
ttk::notebook::enableTraversal .nb
.CE
.SH "SEE ALSO"
widget(n), grid(n)
.SH "KEYWORDS"
pane, tab
