'\"
'\" Copyright (c) 2004 Joe English
'\" style.n,v 1.9 2005/09/14 17:24:28 jenglish Exp
'\" 
.so man.macros
.TH style n 0.5 tile "Tile Widget Set"
.BS
.SH NAME
style \- Control overall look and feel of widgets
.SH SYNOPSIS
\fBstyle\fR \fIoption\fR ?\fIargs\fR?
.BE
.SH DEFINITIONS
.PP
Each widget is assigned a \fIstyle\fR,
which specifies the set of elements making up the widget
and how they are arranged, along with dynamic and default
settings for element resources.
By default, the style name is the same as the widget's class;
this may be overridden by the \fB-style\fP option. 
.PP
A \fItheme\fR is a collection of elements and styles 
which controls the overall look and feel of an application.
.SH DESCRIPTION
The \fBstyle\fR command takes the following arguments:
.TP
\fBstyle configure \fIstyle\fR ?\fI-option \fR?\fIvalue option value...\fR? ?
Sets the default value of the specified option(s) in \fIstyle\fR.
.TP
\fBstyle map \fIstyle\fR ?\fI-option\fR { \fIstatespec value\fR } ... ?
Sets dynamic values of the specified option(s) in \fIstyle\fR.
See "\fBSTATE MAPS\fR", below.
.TP
\fBstyle layout \fIstyle\fR ?\fIlayoutSpec\fR?
Define the widget layout for style \fIstyle\fR.  
See "\fBLAYOUTS\fR" below for the format of \fIlayoutSpec\fR.
If \fIlayoutSpec\fR is omitted, return the layout specification
for style \fIstyle\fR.
.TP 
\fBstyle element create\fR \fIelementName\fR \fItype\fR ?\fIargs...\fR?
Creates a new element in the current theme of type \fItype\fR.
The only built-in element type is \fIimage\fR (see \fIimage(n)\fR),
although themes may define other element types 
(see \fBTtk_RegisterElementFactory\fR).
.TP 
\fBstyle element names\fR
Returns the list of elements defined in the current theme.
.TP 
\fBstyle element options \fIelement\fR
Returns the list of \fIelement\fR's options.
.TP
\fBstyle theme create\fR \fIthemeName\fR ?\fB-parent \fIbasedon\fR? ?\fB-settings \fIscript...\fR ?
Creates a new theme.  It is an error if \fIthemeName\fR already exists.
If \fI-parent\fR is specified, the new theme will inherit
styles, elements, and layouts from the parent theme \fIbasedon\fB.
If \fI-settings\fR is present, \fIscript\fP is evaluated in the
context of the new theme as per \fBstyle theme settings\fP.
.TP
\fBstyle theme settings \fIthemeName\fP \fIscript\fP
Temporarily sets the current theme to \fIthemeName\fR, 
evaluate \fIscript\fR, then restore the previous theme.
Typically \fIscript\fP simply defines styles and elements,
though arbitrary Tcl code may appear.
.TP
\fBstyle theme names\fR
Returns a list of the available themes.
.TP
\fBstyle theme use\fR \fIthemeName\fR
Sets the current theme to \fIthemeName\fR, and refreshes all widgets.

.SH LAYOUTS
A \fIlayout\fP specifies a list of elements, each followed
by one or more options specifying how to arrange the element.
The layout mechanism uses a simplified version of the \fBpack\fP
geometry manager: given an initial cavity,
each element is allocated a parcel.
Valid options are:
.TP 
\fB-side \fIside\fR
Specifies which side of the cavity to place the element;
one of \fBleft\fP, \fBright\fP, \fBtop\fP, or \fBbottom\fP.
If omitted, the element occupies the entire cavity.
.TP
\fB-sticky \fI[nswe]\fR
Specifies where the element is placed inside its allocated parcel.
.TP
\fB-children \fI{ sublayout... }\fR
Specifies a list of elements to place inside the element.
.\" Also: -border, -unit, -expand: may go away.
.PP
For example:
.CS
style layout Horizontal.TScrollbar {
    Scrollbar.trough -children {
        Scrollbar.leftarrow -side left
        Scrollbar.rightarrow -side right
        Horizontal.Scrollbar.thumb -side left -sticky ew
    }
}
.CE


.SH "STATE MAPS"
\fI@@@ describe...\fR


.SH "SEE ALSO"
tile-intro, widget, pixmap
.SH KEYWORDS
style, theme, appearance

