# This script demonstrates how to create a non-themed button using the Tile
# Tk extension. In this case we regain control of the button background
# colour by loosing the XP themeing. However we retain the current theme
# settings for all the other elements - this meand the focus ring will 
# look right and the text will use the right font and the correct
# shading for disabled buttons.
#
# Note that we are defining this for the current theme. On Windows XP 
# tile defaults to xpnative and so this override is in effect in this theme.
# If you switch to another theme - eg: plastik you will get a plastik themed
# button.

package require Tk
package require tile

# -------------------------------------------------------------------------

# We import the border element from the default theme.
style element create plain.border from default

# Create a new layout style for our custom button which uses default
# elements and our imported element for the border.

style layout Plain.TButton {
    background -children {
        plain.border -children {
            focus -children {
                padding -children {
                    label -sticky news
                }
            }
        }
    }
}

# Configure our custom style so it looks like a button
style configure Plain.TButton -relief raised -shiftrelief 1

# If we want to fix the colour to something for this style then:
style configure Plain.TButton -background LightSteelBlue

# Configure the event map so that it depresses when clicked.
style map Plain.TButton -relief {
    {!disabled pressed} sunken
}

# -------------------------------------------------------------------------
# Sample application.

ttk::button .bn -text Normal
ttk::button .bp -text Plain -style Plain.TButton
ttk::button .bx -text Exit -underline 1 -command exit
grid .bn .bp -padx 2 -pady 2
grid .bx - -pady 2
bind . <Control-F2> {console show}
