#include <windows.h>
#include <tcl.h>
#include <tk.h>


#define EXTERNC extern "C" 
#define EXPORT EXTERNC _declspec(dllexport)


template <class T> T* delete_ptr (T* ptr) 
{
    if (ptr != 0) {
	delete ptr;
	ptr = 0;
    } 
    return ptr;
}

template <class T> T* delete_array (T* ptr)
{
    if (ptr != 0) {
	delete []ptr;
	ptr = 0;
    } 
    return ptr;
}


EXPORT int Tktrans_Init (Tcl_Interp *pInterp);


class TkRegion {
    public:
    static void OnExit (ClientData);
    static int SetTopLevel (ClientData data, Tcl_Interp *pInterp,
	    int objc, Tcl_Obj *const objv []);
    static int SetWidget (ClientData data, Tcl_Interp *pInterp,
	    int objc, Tcl_Obj *const objv []);
    protected:
    static void DeleteRegionData (LPRGNDATA pRgnData);
    static LPRGNDATA CreateRegionData (const int size);
    static HRGN	AddRegionData (HRGN hOrigin, LPRGNDATA pData, const int size);
    static int SetTkWindowRegion (Tcl_Interp *pInterp, HWND hwnd,
	    Tcl_Obj *pPicture);
};


