
# bindings ------------------------

bind . <ButtonPress-1> {
	set wx [winfo rootx .]
	set wy [winfo rooty .]
	set X %X; set Y %Y
}


bind . <Button1-Motion> {
	set dx [expr %X - $X]
	set dy [expr %Y - $Y]
	set nx [expr $wx + $dx]
	set ny [expr $wy + $dy]
	wm geometry . [join "+ $nx + $ny" {}]
}

bind . <Alt-F4> {exit}
bind . <F2> {console show}

#----------------------------------
# Main Script
#----------------------------------

load [file dirname [info script]]/TkTrans.dll

image create photo test -file test.gif
image create photo test2 -file test2.gif

wm overrideredirect . 1

# very important to ensure that the toplevel has been created
update

# apply the first image to the toplevel
tktrans::settoplevel . test

# make a canvas with an image item storing the first image
canvas .c
pack .c
.c create image 0 0 -image test -anchor nw

# create a button with the second image
# button will close application
button .b -image test2 -highlightthickness 0 -relief flat -bd 0 -command exit
.c create window 100 90 -window .b

# shape the button 
tktrans::setwidget .b test2

#----------------------------------