#include "def.h"

inline long getcolor (unsigned char *ptr, int offsets[])
{
    DWORD color = RGB (*(ptr + offsets[0]), *(ptr + offsets[1]),
	    *(ptr + offsets[2]));
    return color;
}

void TkRegion::OnExit (ClientData)
{

}

int TkRegion::SetWidget (ClientData data, Tcl_Interp *pInterp,
	int objc, Tcl_Obj *const objv [])
{
    HWND hwnd = NULL;

    if (objc < 2 || objc > 3) {
	Tcl_SetResult (pInterp,
		"wrong # args: should be \"setwidget windowid ?imageid?\"",
		TCL_STATIC);
	return TCL_ERROR;
    }

    if (Tcl_VarEval (pInterp, "winfo id ",
	    Tcl_GetStringFromObj (objv[1], NULL), NULL) == TCL_OK) {
	int iwnd;
		
	if (Tcl_GetIntFromObj (pInterp, Tcl_GetObjResult (pInterp), &iwnd)
		== TCL_OK) {
	    hwnd = reinterpret_cast<HWND>(iwnd);
	}
    }

    if (hwnd == NULL) {
	Tcl_SetResult (pInterp, "could not access the window handle",
		TCL_STATIC);
	return TCL_ERROR;
    }

    if (objc == 2) {
	SetWindowRgn (hwnd, NULL, TRUE);
	return TCL_OK;
    }

    return SetTkWindowRegion (pInterp, hwnd, objv[2]);
}


int TkRegion::SetTopLevel (ClientData data, Tcl_Interp *pInterp,
	int objc, Tcl_Obj *const objv [])
{
    if (objc < 2 || objc > 3) {
	Tcl_SetResult(pInterp,
		"wrong # args: should be \"settoplevel windowid ?imageid?\"",
		TCL_STATIC);
	return TCL_ERROR;
    }

    HWND hwnd = NULL;

    if (Tcl_VarEval(pInterp, "winfo id ",
	    Tcl_GetString (objv[1]), NULL) == TCL_OK) {
	int iwnd;

	if (Tcl_GetIntFromObj(pInterp, Tcl_GetObjResult(pInterp), &iwnd)
		== TCL_OK) {
	    hwnd = reinterpret_cast<HWND>(iwnd);
	}
    }

    if (hwnd == NULL) {
	Tcl_SetResult (pInterp, "could not access the window handle",
		TCL_STATIC);
	return TCL_ERROR;
    }

    const int classsize = 50;
    int returnval;
    TCHAR myname[classsize];

    while ((returnval = GetClassName (hwnd, myname, classsize))
	    && strcmp (myname, "TkTopLevel")) {
	hwnd = GetParent (hwnd);
    }

    if (returnval == 0) {
	Tcl_SetResult (pInterp, "Could not get the class name of window",
		TCL_STATIC);
	return TCL_ERROR;
    }

    if (objc == 2) {
	SetWindowRgn (hwnd, NULL, TRUE);
	return TCL_OK;
    }

    return SetTkWindowRegion (pInterp, hwnd, objv[2]);
}


int Tktrans_Init (Tcl_Interp *pInterp)
{
    if (
#ifdef USE_TCL_STUBS
	Tcl_InitStubs(pInterp, "8.0", 0)
#else
	Tcl_PkgRequire(pInterp, "Tcl", "8.0", 0)
#endif
	== NULL) {
	return TCL_ERROR;
    }
    if (
#ifdef USE_TK_STUBS
	Tk_InitStubs(pInterp, "8.0", 0)
#else
	Tcl_PkgRequire(pInterp, "Tk", "8.0", 0)
#endif
	== NULL) {
	return TCL_ERROR;
    }
    if (Tcl_PkgProvide(pInterp, "Tktrans", "0.9") != TCL_OK) {
	return TCL_ERROR;
    }
    Tcl_CreateObjCommand (pInterp, "tktrans::settoplevel",
	    TkRegion::SetTopLevel, NULL, NULL);
    Tcl_CreateObjCommand (pInterp, "tktrans::setwidget",
	    TkRegion::SetWidget, NULL, NULL);
    Tcl_CreateExitHandler (TkRegion::OnExit, NULL);
    return TCL_OK;
}

LPRGNDATA TkRegion::CreateRegionData(const int imgsize)
{
    int datasize = sizeof (RGNDATAHEADER) + imgsize*sizeof(RECT);
    BYTE *pData = new BYTE [datasize];
    LPRGNDATA pRgnData = reinterpret_cast<LPRGNDATA> (pData);
    return pRgnData;
}

void TkRegion::DeleteRegionData(LPRGNDATA pRgnData)
{
    BYTE *pdata = reinterpret_cast<BYTE*>(pRgnData);
    delete_array (pdata);
}


HRGN	TkRegion::AddRegionData (HRGN hOrigin, LPRGNDATA pRgnData,
	const int size)
{
    pRgnData->rdh.nCount = size;
    HRGN hNewRgn = ExtCreateRegion (NULL, size*sizeof(RECT)
	    + sizeof(RGNDATAHEADER), pRgnData);
    if (hOrigin != NULL) {
	if (ERROR == CombineRgn (hNewRgn, hNewRgn, hOrigin, RGN_OR)) {
	    CloseHandle (hNewRgn);
	    return hOrigin;
	}
	CloseHandle (hOrigin);
    }
    return hNewRgn;
}



int TkRegion::SetTkWindowRegion (Tcl_Interp *pInterp, HWND hwnd,
	Tcl_Obj *pPicture)
{
    Tk_PhotoHandle photo = Tk_FindPhoto (pInterp,
	    Tcl_GetStringFromObj (pPicture, NULL));
    if (photo == 0) {
	Tcl_SetResult (pInterp, "could not find image", TCL_STATIC);
	Tcl_AppendResult (pInterp, Tcl_GetStringFromObj (pPicture, NULL), NULL);
	return TCL_ERROR;
    }

    Tk_PhotoImageBlock img;
    Tk_PhotoGetImage (photo, &img);

    unsigned char *ptr = img.pixelPtr;
    int nextline = img.pitch - img.pixelSize * (img.width);
    int rectcounter = 0;
    //int imgsize = img.width * img.height;
    const int imgsize = 100; // 100 rectangles at a time

    LPRGNDATA pRgnData = CreateRegionData (imgsize);
    LPRECT rects = reinterpret_cast<RECT *>(pRgnData->Buffer);

    HRGN hPicRegion = NULL;
    int y = 0;
    int x = 0;

    pRgnData->rdh.dwSize = sizeof (pRgnData->rdh);
    pRgnData->rdh.iType = RDH_RECTANGLES;
    // pRgnData->rdh.nCount = rectcounter;
    pRgnData->rdh.nRgnSize = 0;
    pRgnData->rdh.rcBound.left = pRgnData->rdh.rcBound.top = 0;
    pRgnData->rdh.rcBound.right = img.width - 1;
    pRgnData->rdh.rcBound.bottom = img.height - 1;


    while (y < img.height) {
	DWORD color = getcolor (ptr, img.offset);
	if (color != 0x00ff00ff) {
	    rects[rectcounter].top = rects[rectcounter].bottom = y;
	    rects[rectcounter].bottom++;
	    rects[rectcounter].right = rects[rectcounter].left = x;
	    rects[rectcounter].right++;
	    rectcounter++;
	    if (rectcounter >= imgsize) {
		hPicRegion = AddRegionData (hPicRegion, pRgnData, rectcounter);
		rectcounter = 0;
	    }
	}
	ptr += img.pixelSize;
	if (++x == img.width) {
	    x = 0;
	    ++y;
	    ptr += nextline;
	}
    }

    if (rectcounter > 0) {
	hPicRegion = AddRegionData (hPicRegion, pRgnData, rectcounter);
	rectcounter = 0;
    }

    SetWindowRgn (hwnd, hPicRegion, TRUE);
    DeleteRegionData (pRgnData);
    return TCL_OK;
}
