/*-
 * Copyright (c) 1980, 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * support.c
 * various routines to do exec, etc.
 *
 */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <wincon.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <locale.h>
#include "ntport.h"
#include "sh.err.h"
#include "sh.h"
#include "nt.const.h"


DWORD gdwPlatform,gdwVersion;
unsigned short __nt_really_exec = 0,__nt_child_nohupped =0;


static char *pathvar = 0;

void nt_init(void) {

	char *temp;
	char *ptr;
	int rc;
	OSVERSIONINFO osver;

	pathvar=HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,MAX_PATH);
	temp = pathvar;
	memset(temp,0,MAX_PATH);

	osver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	if (!GetVersionEx(&osver)) {
		MessageBox(NULL,"GetVersionEx failed","tcsh",MB_ICONHAND);
		ExitProcess(0xFF);
	}
	gdwVersion = osver.dwMajorVersion;
	if ((ptr = getenv("HOME"))){
		char *s = ptr;
		while(*s){
			if (*s == '\\') *s = '/';
			s++;
		}
		goto skippy;
	}
	
	if(osver.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		char *ptr1,*ptr2,*ptr3;
		ptr1=getenv("USERPROFILE");
		ptr2=getenv("HOMEDRIVE");
		ptr3=getenv("HOMEPATH");
		if (!ptr1 || osver.dwMajorVersion <4) {
			wsprintf(temp,"HOME=%s%s",ptr2?ptr2:"C:",ptr3?ptr3:"\\");
		}
		else if (osver.dwMajorVersion >= 4) {
			wsprintf(temp,"HOME=%s",ptr1);
		}
	}
	else if (osver.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) {
	  wsprintf(temp,"HOME=");
	  ptr = temp; temp += lstrlen(temp);
		rc = GetWindowsDirectory(temp,MAX_PATH);
		if (rc > MAX_PATH) {
			MessageBox(NULL,"This should never happen","tcsh",MB_ICONHAND);
			ExitProcess(0xFF);
		}
		temp = ptr;
	}
	else {
		MessageBox(NULL,"Unknown platform","tcsh",MB_ICONHAND);
	}
	ptr = temp;
	while(*ptr) {
		if(*ptr == '\\') *ptr ='/';
		ptr++;
	}
	putenv(temp);

skippy:
	gdwPlatform = osver.dwPlatformId;

#ifdef SECURE_CD
	{
		char temp[512];
		extern char gcurr_drive;
		if(!GetCurrentDirectory(512,temp))
			ExitProcess((DWORD)-1);
		gcurr_drive=temp[0];
	}
#endif SECURE_CD

	init_stdio();
	nt_init_signals();
	nt_term_init();
	init_hb_subst();
	setlocale(LC_ALL,"");
	init_shell_dll();
	init_plister();
	fork_init();
	init_clipboard();
	return;
}
void nt_cleanup(void){
	HeapFree(GetProcessHeap(),0,pathvar);
	nt_term_cleanup();
	nt_cleanup_signals();
	cleanup_netbios();
}
static unsigned char defcwd[MAX_PATH];
char * forward_slash_get_cwd(char * path, int maxlen) {

	char *ptemp;
	int rc ;
	
	if ((path == NULL) || (maxlen == 0)) {
		path = &defcwd[0];
		maxlen = MAX_PATH;
	}

	rc = GetCurrentDirectory(maxlen,path);
	if (rc > maxlen) {
		errno = ERANGE;
		return NULL;
	}
	ptemp=path;
	while(*ptemp) {
		if (*ptemp == '\\') *ptemp = '/';
		*ptemp++;
	}
	return path;
}
void getmachine (void) {

	char temp[256];
	char *vendor, *ostype;
	OSVERSIONINFO osver;
	SYSTEM_INFO sysinfo;


	memset(&osver,0,sizeof(osver));
	memset(&sysinfo,0,sizeof(sysinfo));
	vendor = "Microsoft";

	tsetenv(STRVENDOR,str2short(vendor));

	osver.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	if (!GetVersionEx(&osver)) {
		MessageBox(NULL,"GetVersionEx failed in getmachine",
			"tcsh",MB_ICONHAND);
		ExitProcess(0xFF);
	}
	GetSystemInfo(&sysinfo);

	if(osver.dwPlatformId == VER_PLATFORM_WIN32_NT) {
		ostype = "WindowsNT";
		wsprintf(temp,"NT %d.%d Build %d (%s)",
			osver.dwMajorVersion,osver.dwMinorVersion,
			osver.dwBuildNumber,
			osver.szCSDVersion[0]?osver.szCSDVersion:"vanilla");
		tsetenv(STRHOSTTYPE,str2short(temp));
	}
	else if (osver.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) {
	  ostype = "Windows9x";
	  wsprintf(temp,"Win9x %d.%d:%d",osver.dwMajorVersion,osver.dwMinorVersion,
			LOWORD(osver.dwBuildNumber));
	  tsetenv(STRHOSTTYPE,str2short(temp));
	}
	else {
		MessageBox(NULL,"Unknown platform","tcsh",MB_ICONHAND);
	}
	tsetenv(STROSTYPE,str2short(ostype));
	switch (sysinfo.wProcessorArchitecture) {
		case PROCESSOR_ARCHITECTURE_INTEL:
			if ( ( sysinfo.wProcessorLevel < 3) || 
				 ( sysinfo.wProcessorLevel > 9)  )
				 sysinfo.wProcessorLevel = 3;
			wsprintf(temp,"i%d86",sysinfo.wProcessorLevel);
			break;
		case PROCESSOR_ARCHITECTURE_ALPHA:
			wsprintf(temp,"Alpha");
			break;
		case PROCESSOR_ARCHITECTURE_MIPS:
			wsprintf(temp,"Mips");
			break;
		case PROCESSOR_ARCHITECTURE_PPC:
			wsprintf(temp,"PPC");
			break;
		default:
			wsprintf(temp,"Unknown");
			break;
	}
	tsetenv(STRMACHTYPE,str2short(temp));

}
void nt_exec(char *prog, char**args) {
//	__try {
		nt_execve(prog,args,NULL);
//	}__except(1) {
//		stderror(ERR_TOOMANY);
//	}

}
void nt_execve(char *prog, char**args, char**envir ) {

	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	HANDLE htemp;
	BOOL bRet;
    DWORD type=0;
	DWORD dwCreationflags;
	unsigned int priority;
	char *argv0;
	char *cmdstr ;
	unsigned int cmdsize,cmdlen,arglen;
	Char *vp;
    char *ptr,*p2;//, *p3;
	char **savedargs;
	int retries=0;
	int hasdot =0;
	int is_winnt, hasspace=0;
	char pathstr[1024];
	char tempquotedbuf[256];

	memset(&si,0,sizeof(si));
	savedargs = args;

	/* 
	 * This memory is not freed because we are exec()ed and will
	 * not be alive long.
	 */
	cmdstr= heap_alloc(MAX_PATH*4);
	argv0 = heap_alloc(MAX_PATH);

	is_winnt = (gdwPlatform != VER_PLATFORM_WIN32_WINDOWS);

	ptr = prog;
	p2 = cmdstr+1; // Leave room for quote if needed
	//p3 = argv0;//+1;

	cmdsize = MAX_PATH*4;
	cmdlen = 1;

	/*
	 * Change '/' to '\\', quote spaces
	 */
	while(*ptr) {
		if (*ptr == '/')
			*ptr = '\\';
		else if (*ptr == '.')
			hasdot = 1;
		else if (*ptr == ' ' ) {
			hasspace = 1;
		}
		*p2++ = *ptr;
		//*p3++ = *ptr;

		ptr++;
		cmdlen++;
	}
	//
	// The fix below is for paths with ./ instead of . on win95
	//
	if ( !is_winnt && cmdstr[1] == '.' && cmdstr[2] == '\\' 
			&& cmdstr[3] == '\\' ) {
		ptr = cmdstr + 3; // move to 2nd '\';
		while(* (ptr +1) ){
			*ptr = *(ptr +1);
			ptr++;
		}
		*ptr = 0;

	}
	if (hasspace) {
		/* put quotes at beginning and end */
		*cmdstr = '"';
		*p2++ = '"';
		//*argv0 = '"';
		//*p3++ = '"';

		cmdlen++;
	}
	else { // Skip initial character we left for quote
		*cmdstr = 'A';
		cmdstr++; 
		//*argv0 ='A';
		//argv0++;
	}
	*p2 = 0;
	// *p3 = 0;


	if (!is_winnt){
		//heap_free(argv0);
		argv0 = NULL;
		goto win95_directly_here;
	}
	else
		wsprintf(argv0,"%s",prog);

retry:

	bRet=GetBinaryType(argv0,&type);
	dprintf("binary type for %s is %d\n",argv0,bRet);
	//
	// For NT, append .EXE and retry
	//
	if (is_winnt && !bRet ) {
        /* Don't append .EXE if it could be a script file */
		if (GetLastError() == ERROR_BAD_EXE_FORMAT){
			errno = ENOEXEC;
			if (!__nt_only_start_exes)
				try_shell_ex(args,1);
			return;
		}
		else if ( retries ){
			if (
				( (argv0[0] == '\\') ||(argv0[0] == '/') ) &&
				( (argv0[1] == '\\') ||(argv0[1] == '/') ) &&
				(!args[1])
			   )
				if (!__nt_only_start_exes)
					try_shell_ex(args,1);
			errno  = ENOENT;
		}
		if (retries > 1){
			return;
		}
		// Try uppercase once and then lower case
		//
		if (!retries)
			wsprintf(argv0,"%s.exe",prog);
		else 
			wsprintf(argv0,"%s.EXE",prog); /* fix for clearcase */
		retries++;
		goto retry;
	}

win95_directly_here:

	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESTDHANDLES;
	htemp= (HANDLE)_get_osfhandle(0);
	DuplicateHandle(GetCurrentProcess(),htemp,GetCurrentProcess(),
						&si.hStdInput,0,TRUE,DUPLICATE_SAME_ACCESS);
	htemp= (HANDLE)_get_osfhandle(1);
	DuplicateHandle(GetCurrentProcess(),htemp,GetCurrentProcess(),
						&si.hStdOutput,0,TRUE,DUPLICATE_SAME_ACCESS);
	htemp= (HANDLE)_get_osfhandle(2);
	DuplicateHandle(GetCurrentProcess(),htemp,GetCurrentProcess(),
						&si.hStdError,0,TRUE,DUPLICATE_SAME_ACCESS);


	/* 
		quotespace hack needed since execv() would have separated args, but
		createproces doesnt
		-amol 9/14/96
	*/

	*args++; // the first arg is the command

	while(*args) {
		short quotespace=0;
		short quotequote=0;

		lstrcat(cmdstr," ");
		cmdlen++;

		ptr = *args;

		arglen = 0;

		if (!*ptr) {
			lstrcat(cmdstr,"\"\"");
			cmdlen += 2;
		}
		while(*ptr) {
			if (*ptr == ' ' || *ptr == '\t') 
				quotespace=1;
			else if (*ptr == '"')
				quotequote = 1;
			ptr++;
			arglen++;
		}
		if (arglen + cmdlen +4 > cmdsize) { // +4 is if we have to quote

			if (arglen + 8 > cmdsize){
				cmdstr = heap_realloc(cmdstr-1,cmdsize+arglen+8);
				cmdstr++;
				cmdsize += arglen+8;
			}
			else{
				cmdstr = heap_realloc(cmdstr-1,cmdsize<<1);
				cmdstr++;
				cmdsize <<=1;
			}

		}
		if (quotespace) 
			lstrcat(cmdstr,"\"");

		if (quotequote){
			tempquotedbuf[0]=0;
			quoteProtect(tempquotedbuf,*args);
			lstrcat(cmdstr,tempquotedbuf);
			cmdlen +=2;
		}
		else
			lstrcat(cmdstr,*args);

		if (quotespace) {
			lstrcat(cmdstr,"\"");
			cmdlen +=2;
		}
		/*
		else if (!quotequote)
			lstrcat(cmdstr,*args);
		*/

		cmdlen += arglen;

		args++;
	}
	dwCreationflags = GetPriorityClass(GetCurrentProcess());
	if (__nt_child_nohupped) {
		dwCreationflags |= DETACHED_PROCESS;
	}
	priority = GetThreadPriority(GetCurrentThread());
	{

		vp = varval(STRNTlamepathfix);

		pathstr[1023] =0 ;
		if (vp != STRNULL) {
			if (GetEnvironmentVariable("PATH",pathstr,1024) <1024 ) {
				ptr = pathstr;
				while(*ptr) {
					if (*ptr == '/')
						*ptr = '\\';
					ptr++;
				}
				SetEnvironmentVariable("PATH",pathstr);
			}
		}

	}
	if (is_winnt)
		dwCreationflags |= CREATE_SUSPENDED;

	dwCreationflags |= CREATE_DEFAULT_ERROR_MODE;

re_cp:
	dprintf("argv0 %s cmdstr %s\n",argv0,cmdstr);
	if (!CreateProcess(argv0,
					   cmdstr,
					   NULL,
					   NULL,
					   TRUE, // need this for redirecting std handles
					   dwCreationflags,
					   NULL,//envcrap,
					   NULL,
					   &si,
					   &pi) ){

		if (GetLastError() == ERROR_BAD_EXE_FORMAT) {
			if (!__nt_only_start_exes)
				try_shell_ex(savedargs,1);
			errno  = ENOEXEC;
		}
		else
			errno  = ENOENT;
		if (!is_winnt && !hasdot) { //append '.' to the end if needed
			lstrcat(cmdstr,".");
			hasdot=1;
			goto re_cp;
		}
	}
	else{
		int gui_app ;
		char guivar[50];

		if (GetEnvironmentVariable("TCSH_NOASYNCGUI",guivar,50))
			gui_app=0;
		else
			gui_app= is_gui(argv0);

		if (is_winnt && !SetThreadPriority(pi.hThread,priority) ) {
			priority =GetLastError();
		}
		if (is_winnt)
			ResumeThread(pi.hThread);
		errno= 0;
		
		if (__nt_really_exec||__nt_child_nohupped || gui_app){
			ExitProcess(0);
		}
		else {
			DWORD exitcode=0;
			WaitForSingleObject(pi.hProcess,INFINITE);
			(void)GetExitCodeProcess(pi.hProcess,&exitcode);
			CloseHandle(pi.hProcess);
			CloseHandle(pi.hThread);
			/*
			 * If output was redirected to /dev/clipboard,
			 * we need to close the pipe handles
			 */
			if (is_dev_clipboard_active) {
				CloseHandle((HANDLE)_get_osfhandle(0));
				CloseHandle((HANDLE)_get_osfhandle(1));
				CloseHandle((HANDLE)_get_osfhandle(2));
				CloseHandle(si.hStdInput);
				CloseHandle(si.hStdOutput);
				CloseHandle(si.hStdError);
				WaitForSingleObject(ghdevclipthread,60*1000);
			}
			ExitProcess(exitcode);
		}
	}
}
/* This function from  Mark Tucker (mtucker@fiji.sidefx.com) */
void quoteProtect(char *dest, char *src) {
	char	*prev, *curr;
	for (curr = src; *curr; curr++) {

		// Protect " from MS-DOS expansion
		if (*curr == '"') {
			// Now, protect each preceeding backslash
			for (prev = curr-1; prev >= src && *prev == '\\'; prev--)
				*dest++ = '\\';

			*dest++ = '\\';
		}
		*dest++ = *curr;
	}
	*dest = 0;
}


int gethostname(char *buf, int len) {
	GetComputerName(buf,&len);
	return 0;
}
int nt_chdir (char *path) {
	char *tmp = path;
	if (gdwPlatform !=VER_PLATFORM_WIN32_NT) {
		while(*tmp) {
			if (*tmp == '/') *tmp = '\\';
			tmp++;
		}
	}
	return _chdir(path);
}
LONG WINAPI uhef( EXCEPTION_POINTERS *lpep) {
	ExitProcess(lpep->ExceptionRecord->ExceptionCode);
	return 0; // not reached
}
extern void mainCRTStartup(void *);
void silly_entry(void *peb) {
	char * path1=NULL;
	int rc;

	//SetUnhandledExceptionFilter(uhef);

	rc = GetEnvironmentVariable("Path",path1,0);
	if ( rc !=0) {

		path1 =heap_alloc(rc);

		GetEnvironmentVariable("Path",path1,rc);
		SetEnvironmentVariable("Path",NULL);
		/*SetEnvironmentVariable("PATH",NULL);*/
		SetEnvironmentVariable("PATH",path1);

		heap_free(path1);
	}
	mainCRTStartup(peb);
}
